# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, TYPE_CHECKING

from azure.core.rest import HttpRequest, HttpResponse
from azure.mgmt.core import ARMPipelineClient

from . import models
from ._configuration import SubscriptionClientConfiguration
from ._serialization import Deserializer, Serializer
from .operations import (
    AliasOperations,
    BillingAccountOperations,
    Operations,
    SubscriptionOperations,
    SubscriptionPolicyOperations,
    SubscriptionsOperations,
    TenantsOperations,
)

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials import TokenCredential


class SubscriptionClient:  # pylint: disable=client-accepts-api-version-keyword,too-many-instance-attributes
    """The subscription client.

    :ivar subscriptions: SubscriptionsOperations operations
    :vartype subscriptions: azure.mgmt.subscription.operations.SubscriptionsOperations
    :ivar tenants: TenantsOperations operations
    :vartype tenants: azure.mgmt.subscription.operations.TenantsOperations
    :ivar subscription: SubscriptionOperations operations
    :vartype subscription: azure.mgmt.subscription.operations.SubscriptionOperations
    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.subscription.operations.Operations
    :ivar alias: AliasOperations operations
    :vartype alias: azure.mgmt.subscription.operations.AliasOperations
    :ivar subscription_policy: SubscriptionPolicyOperations operations
    :vartype subscription_policy: azure.mgmt.subscription.operations.SubscriptionPolicyOperations
    :ivar billing_account: BillingAccountOperations operations
    :vartype billing_account: azure.mgmt.subscription.operations.BillingAccountOperations
    :param credential: Credential needed for the client to connect to Azure. Required.
    :type credential: ~azure.core.credentials.TokenCredential
    :param base_url: Service URL. Default value is "https://management.azure.com".
    :type base_url: str
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
     Retry-After header is present.
    """

    def __init__(
        self, credential: "TokenCredential", base_url: str = "https://management.azure.com", **kwargs: Any
    ) -> None:
        self._config = SubscriptionClientConfiguration(credential=credential, **kwargs)
        self._client = ARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)
        self._serialize.client_side_validation = False
        self.subscriptions = SubscriptionsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.tenants = TenantsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.subscription = SubscriptionOperations(self._client, self._config, self._serialize, self._deserialize)
        self.operations = Operations(self._client, self._config, self._serialize, self._deserialize)
        self.alias = AliasOperations(self._client, self._config, self._serialize, self._deserialize)
        self.subscription_policy = SubscriptionPolicyOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.billing_account = BillingAccountOperations(self._client, self._config, self._serialize, self._deserialize)

    def _send_request(self, request: HttpRequest, **kwargs: Any) -> HttpResponse:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = client._send_request(request)
        <HttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/dpcodegen/python/send_request

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.HttpResponse
        """

        request_copy = deepcopy(request)
        request_copy.url = self._client.format_url(request_copy.url)
        return self._client.send_request(request_copy, **kwargs)

    def close(self):
        # type: () -> None
        self._client.close()

    def __enter__(self):
        # type: () -> SubscriptionClient
        self._client.__enter__()
        return self

    def __exit__(self, *exc_details):
        # type: (Any) -> None
        self._client.__exit__(*exc_details)
